//
//  MCReportWrapper.h
//  MCReporting
//
//  Created by Alykhan Jetha on 11/11/05.
//  Copyright 2005 Marketcircle Inc.. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class MCReportLayout;
@class MCReportFScriptClassLoader;

@interface MCReportWrapper : NSFileWrapper {
	NSString *originalPath;
	NSDictionary *infoDictionary;
	NSPrintInfo *printInfo;
	MCReportLayout *reportLayout;
	BOOL worksWithMergeKit;
	BOOL isEmbedded;
	
	NSNumber *databaseRepresentationID;
	NSString *databaseRepresentationEntityName;
	
	MCReportFScriptClassLoader *fscriptClassLoader;
}

/*!
 Set to true if this template is found in the embedded paths
 */
@property (assign) BOOL isEmbedded;

/*!
 In case where the report wrapper's permanent location is a bag of bytes in a database, you can set and use these variables to get to or reference the raw bytes (i.e. BIReportTemplate & 234100)
 */
@property (retain) NSNumber *databaseRepresentationID;
@property (retain) NSString *databaseRepresentationEntityName;

/*!
 If the original paths match, then returns YES or if the databaseIDs match then returns YES.
 */
- (BOOL)isEqualToReportWrapper:(MCReportWrapper *)aWrapper;

- (NSString *)originalPath;

// returns yes if there is a Template.html, Template.rtf, Template.txt and Info.plist
- (BOOL)worksWithMergeKit;
- (BOOL)hasHTMLTemplate;
- (BOOL)hasRTFTemplate;
- (BOOL)hasTXTTemplate;

	// derived from info dictionary - NSStringEncoding. NSMacOSRomanStringEncoding is default
- (NSStringEncoding)mergeStringEncoding;

	// reads the .html or .rtf or .txt data as a string encoded using mergeStringEncoding
- (NSString *)mergeTemplateStringValue;



	/* If there is a Script.fscript in the wrapper, it is returned as a string. The script must be in UTF8 encoding.
       Reserved keywords are: objectContext, document, currentUser, object, objects, rightNow and variables

       In your script, you must put the things you want in the report in the variables dictionary. Those values and keys will then be put in the mergePack and thus accessible by the merge engine
 	*/
// TODO: Deprecate?
- (NSString *)script;

/*!
 Looks for debug = 1 in the info plist
 */
- (BOOL)debug;


- (BOOL)worksWithWebView;
- (NSDictionary *)webViewProperties;
- (NSString *)webViewName;
- (NSString *)webViewInitialAction;

/*!
 Loads fscript classes. If debug is yes, then reloads on each call.
 */
- (BOOL)webViewLoadClasses;

- (Class)webViewActionClassForAction:(NSString *)aActionName;
- (SEL)webViewSelectorForAction:(NSString *)aActionName;
- (NSString *)webViewFilenameForAction:(NSString *)aActionName;

- (NSDictionary *)webViewActionDetailsForName:(NSString *)aActionName;
- (NSString *)webViewClassnameForAction:(NSString *)aActionName;
- (NSString *)webViewSelectorNameForAction:(NSString *)aActionName;

- (NSString *)webViewSharedResourcesPath;




- (NSDictionary *)infoDictionary;
- (NSPrintInfo *)printInfo;
- (MCReportLayout *)reportLayout;

- (NSString *)displayName;

- (NSString *)behavior;

- (BOOL)isValidForBehaviors:(NSArray *)behav typeIdentifier:(NSString *)aName;

	// legacy support
- (BOOL)isValidForEntityName:(NSString *)entityName;

@end

@interface NSFileWrapper (MCReportImageSupport)

// returns the next available (unused) name such as img1.jpg, MyImage2.png etc...
// aFilename must be the last path component
// this is slightly better than the default behavior
- (NSString *)nextPreferredResourceNameForFilename:(NSString *)aFilename;

// absorbs the data at path and returns the given embedded name
- (NSString *)takeNextReportImageResourceAtPath:(NSString *)fullpath;

- (NSImage *)imageForReportImageResourceNamed:(NSString *)preferredName;

@end
